%------------------------------------------------------------------------------
% File     : NUM709^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 28h
% Version  : Especial.
% English  : pl (ts x y) y = ts (suc x) y

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz28h [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.00 v7.1.0, 0.12 v7.0.0, 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v4.1.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :    8 (   0 unit;   6 type;   0 defn)
%            Number of atoms       :   20 (   2 equality;   5 variable)
%            Maximal formula depth :    8 (   4 average)
%            Number of connectives :   14 (   0   ~;   0   |;   0   &;  14   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    7 (   6   :;   0   =)
%            Number of variables   :    2 (   0 sgn;   2   !;   0   ?;   0   ^)
%                                         (   2   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(ts,type,(
    ts: nat > nat > nat )).

thf(suc,type,(
    suc: nat > nat )).

thf(satz28d,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( ts @ ( suc @ Xx ) @ Xy )
      = ( pl @ ( ts @ Xx @ Xy ) @ Xy ) ) )).

thf(satz28h,conjecture,
    ( ( pl @ ( ts @ x @ y ) @ y )
    = ( ts @ ( suc @ x ) @ y ) )).

%------------------------------------------------------------------------------
